import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/domain/models/models.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import '../../orders_table/widgets/status/order_status_modal.dart';

class UserInformation extends StatelessWidget {
  final OrderData? order;

  const UserInformation({super.key, this.order});

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        color: Style.white,
        borderRadius: BorderRadius.circular(16),
        border: Border.all(color: Style.borderColor),
      ),
      padding: const EdgeInsets.all(20),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              CommonImage(
                url: order?.user?.img ?? "",
                width: 56,
                height: 56,
                radius: 30,
                isResponsive: false,
              ),
              16.horizontalSpace,
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    AutoSizeText(
                      "${order?.user?.firstname ?? ''} ${order?.user?.lastname ?? ''}",
                      style: Style.interMedium(size: 20),
                      minFontSize: 16,
                      maxLines: 1,
                    ),
                    2.verticalSpace,
                    Text(
                      order?.user?.phone ?? order?.user?.email ?? '',
                      style: Style.interRegular(
                        size: 16,
                        color: Style.iconColor,
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
          8.verticalSpace,
          const Divider(),
          8.verticalSpace,
          Text(
            AppHelpers.getTranslation(order?.deliveryType == TrKeys.pickup
                ? TrKeys.pointAddress
                : TrKeys.deliveryAddress),
            style: Style.interNormal(size: 16, color: Style.iconColor),
          ),
          12.verticalSpace,
          Text(
            order?.myAddress?.location?.address ??
                order?.deliveryPoint?.address?.address ??
                '' "",
            style: Style.interNormal(
              size: 18,
            ),
          ),
          8.verticalSpace,
          const Divider(),
          8.verticalSpace,
          _priceInformation(),
          8.verticalSpace,
          const Divider(),
          8.verticalSpace,
          CustomButton(
            title: AppHelpers.getTranslation(TrKeys.editStatusNote),
            onTap: () {
              AppHelpers.showAlertDialog(
                  context: context,
                  child: OrderStatusModal(
                    onlyShow: (order?.type == 1),
                  ),
                  backgroundColor: Style.bg);
            },
          ),
        ],
      ),
    );
  }

  Column _priceInformation() {
    return Column(
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              AppHelpers.getTranslation(TrKeys.subtotal),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
            Text(
              AppHelpers.numberFormat(
                number: order?.originPrice,
                isOrder: true,
                symbol: order?.currency?.symbol,
              ),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
          ],
        ),
        20.verticalSpace,
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              AppHelpers.getTranslation(TrKeys.tax),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
            Text(
              AppHelpers.numberFormat(
                number: order?.totalTax,
                isOrder: true,
                symbol: order?.currency?.symbol,
              ),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
          ],
        ),
        20.verticalSpace,
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              AppHelpers.getTranslation(TrKeys.serviceFee),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
            Text(
              AppHelpers.numberFormat(
                number: order?.serviceFee,
                isOrder: true,
                symbol: order?.currency?.symbol,
              ),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
          ],
        ),
        20.verticalSpace,
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              AppHelpers.getTranslation(TrKeys.deliveryFee),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
            Text(
              AppHelpers.numberFormat(
                number: order?.deliveryFee,
                isOrder: true,
                symbol: order?.currency?.symbol,
              ),
              style: Style.interRegular(
                color: Style.black,
                size: 16,
                letterSpacing: -0.4,
              ),
            ),
          ],
        ),
        if ((order?.totalDiscount ?? 0) != 0)
          Column(
            children: [
              20.verticalSpace,
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text(
                    AppHelpers.getTranslation(TrKeys.discount),
                    style: Style.interRegular(
                      color: Style.black,
                      size: 16,
                      letterSpacing: -0.4,
                    ),
                  ),
                  Text(
                    "-${AppHelpers.numberFormat(
                      number: order?.totalDiscount,
                      isOrder: true,
                      symbol: order?.currency?.symbol,
                    )}",
                    style: Style.interRegular(
                      color: Style.red,
                      size: 16,
                      letterSpacing: -0.4,
                    ),
                  ),
                ],
              ),
            ],
          ),
        if ((order?.coupon?.price ?? 0) != 0)
          Column(
            children: [
              20.verticalSpace,
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text(
                    AppHelpers.getTranslation(TrKeys.coupon),
                    style: Style.interRegular(
                      color: Style.black,
                      size: 16,
                      letterSpacing: -0.4,
                    ),
                  ),
                  Text(
                    "-${AppHelpers.numberFormat(
                      number: order?.coupon?.price,
                      isOrder: true,
                      symbol: order?.currency?.symbol,
                    )}",
                    style: Style.interRegular(
                      color: Style.red,
                      size: 16,
                      letterSpacing: -0.4,
                    ),
                  ),
                ],
              ),
            ],
          ),
        20.verticalSpace,
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              AppHelpers.getTranslation(TrKeys.totalPrice),
              style: Style.interNormal(
                color: Style.black,
                size: 18,
                letterSpacing: -0.4,
              ),
            ),
            Text(
              AppHelpers.numberFormat(
                number: order?.totalPrice,
                isOrder: true,
                symbol: order?.currency?.symbol,
              ),
              style: Style.interRegular(
                color: Style.black,
                size: 32,
                letterSpacing: -0.4,
              ),
            ),
          ],
        ),
        if (order?.transactions != null && order!.transactions!.isNotEmpty)
          ...order!.transactions!.map(
            (t) => Column(
              children: [
                20.verticalSpace,
                OrderTransactionItem(
                  iconData: t.paymentSystem?.tag == 'wallet'
                      ? Remix.wallet_3_fill
                      : t.paymentSystem?.tag == 'cash'
                          ? Remix.money_dollar_box_fill
                          : Remix.bank_card_2_line,
                  title:
                      "${t.paymentSystem?.tag} (${AppHelpers.getTranslation(t.status ?? '')})",
                  price: t.price,
                )
              ],
            ),
          )
      ],
    );
  }
}
